<?php

/* API Key and API Pass are unique credentials for each user which helps SitePad server to recognize the user. When you make the API call fpr the first time you can pass empty api key and pass, so the SitePad server will create a new user and return the API Key and Pass in response. Save these credentials for future sessions */

function save_api_credentials($user){
	
	// Save the API Key pass in a secure file/database so that you can load it for making future API calls
	file_put_contents('/home/USERNAME/private/sitepad.php', json_encode($user));
	
	return true;
}

function load_api_credentials(){
	
	// Load the API Key pass from the secure file/database you stored using the save_api_credentials() function
	$return = file_get_contents('/home/USERNAME/private/sitepad.php');
	if(!empty($return)){
		$return = json_decode($return, true);
	}else{
		// Pass empty API Key pass to create a new user and get the API Key pass in result
		$return['apikey'] = '';
		$return['apipass'] = '';
	}
	
	return $return;
}

// Your function to report an error
function report_error($error){
	foreach($error as $k => $v){
		echo $v.'<br />';
	}
}

// SitePad license Key. For custom/proprietary control panel you need to contact the SitePad License team to get a license. sales@sitepad.com
$sitepad_license = 'SMUSH-XXXXX-XXXXX-XXXXX-XXXXX';

/* You can choose from our available servers : http://sitepad.com/wiki/Servers 
 * If you would like to use your custom URL for editor you can use a custom URL eg : https://sitebuilder.myhost.com
 * However for custom URL you will need to add a CNAME record of your URL to point to one of our editor servers eg : us.sitepad.com
 * In order to use SSL please contact SitePad team to install a certificate
*/
$sitepad_editor_url = 'https://us.sitepad.com';

$username = 'USERNAME'; // The control panel username
$post['sm_email'] = 'user@email.com'; // The user's Email address
$post['sm_goto_cp'] = 'https://my.controlpanel.url'; // The URL where the user will be returned after loggin out from SitePad Editor server
$post['sm_no_demos'] = false; // Set this to true if you do not want to show the template demos to the user from the editor

/* The DOMAINS LIST */
$domainroots = array();
$domainroots['example.com'] = '/home/username/public_html';
$domainroots['addon.example.com'] = '/home/username/public_html/addon';
$domainroots['subdomain.example.com'] = '/home/username/public_html/subdomain';
$domainroots['parked.example.com'] = '/home/username/public_html';

/* The FTP PATH of the domains */
$domain_ftp_paths = array();
$domain_ftp_paths['example.com'] = '/public_html';
$domain_ftp_paths['addon.example.com'] = '/public_html/addon';
$domain_ftp_paths['subdomain.example.com'] = '/public_html/subdomain';
$domain_ftp_paths['parked.example.com'] = '/public_html';

/* FTP CREDENTIALS */
$ftp_user = 'user@domain.com'; // FTP Username
$ftp_pass = 'RANDOMPASS'; // FTP Password
$ftp_host = 'ftp.server.com'; // FTP HOST
$ftp_port = 21; // FTP PORT

if(!empty($post['sm_brand_demos'])){
	
	// We need the http:// prefix
	$post['sm_brand_demos'] = substr($post['sm_brand_demos'], 0, 4) != 'http' ? 'http://'.$post['sm_brand_demos'] : $post['sm_brand_demos'];
	
	// Add a trailing slash
	$post['sm_brand_demos'] = substr($post['sm_brand_demos'], -1) != '/' ? $post['sm_brand_demos'].'/' : $post['sm_brand_demos'];
}

$post['sm_data'] = array(
	'panel' => 'control_panel_name',
	'domains' => $domainroots,
	'email' => $post['sm_email'],
	'username' => $username,
	'ftp_paths' => $domain_ftp_paths,
	'ftp_user' => $ftp_user,
	'ftp_pass' => $ftp_pass,
	'ftp_host' => $ftp_host,
	'ftp_port' => $ftp_port
);

/* // OPTIONAL PARAMETERS

// BRANDING OPTIONS
$post['sm_brand'] = 'CUSTOMBRAND'; // Custom brand name. Default : SitePad
$post['sm_brand_app'] = 'CUSTOMBRAND Website Builder'; // Custom website builder name. Default : SitePad Website Builder
$post['sm_brand_editor'] = 'CUSTOMBRAND Editor'; // Custom editor name. Default : SitePad Editor
$post['sm_brand_url'] = 'https://myhost.com'; // Website URL, will be displayed in footer. Default : https://sitepad.com
$post['sm_brand_logo'] = 'https://myhost.com/logo.png'; // Custom Logo (100px x 100px transparent PNG) Default : SitePad logo
$post['sm_brand_demos'] = 'https://demos.sitebuilder.myhost.com'; // You can use a custom URL for Demos. However you will need to add a CNAME record of this demo to point to demos.sitepad.com. In order to use SSL please contact SitePad team to install a certificate

// OPTIONAL PARAMETERS END */

$user = load_api_credentials();

$url = $sitepad_editor_url.'/site-admin/?sm_create_session=1&sm_apikey='.$user['apikey'].'&sm_apipass='.$user['apipass'].'&sm_license='.$sitepad_license;

	
// Set the curl parameters.
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 15);

// Turn off the server and peer verification (TrustManager Concept).
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);

// Follow redirects
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);
		
if(!empty($post)){
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post));
}

// Is there a Cookie
if(!empty($cookie)){
	curl_setopt($ch, CURLOPT_COOKIESESSION, true);
	curl_setopt($ch, CURLOPT_COOKIE, $cookie);
}

if($header){
	curl_setopt($ch, CURLOPT_HEADER, 1);
	curl_setopt($ch, CURLOPT_NOBODY, true);
	curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:2.0.1) Gecko/20100101 Firefox/4.0.1');
}

curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

// Get response from the server.
$resp = curl_exec($ch);
$curl_err = curl_error($ch);
curl_close($ch);

$ret = json_decode($resp, true);
	
// Are there any errors ?
if(!empty($ret['error'])){
	foreach($ret['error'] as $k => $v){
		$error[$k] = $v;
	}
	report_error($error);
	die();
}

// Do we have to store the API KEY and PASS
if(!empty($ret['apikey'])){
	
	$user['apikey'] = $ret['apikey'];
	$user['apipass'] = $ret['apipass'];
	
	//r_print($user);
	save_api_credentials($user);
	
}
	
// Did we get the session URL
if(!empty($ret['sid'])){
	
	$redirect_url = $sitepad_editor_url.'/site-admin/?as='.$ret['sid'];
	
	$redirect_url .= '&cplang=it_IT'; // Use this to load a particular language for the user

	//echo $redirect_url;die();
	
	// Redirect the user to the editor server
	header("Location: ".$redirect_url);
	
}